# BOSS

Projet front-end basé sur Vite, avec génération d’assets CSS depuis SCSS et une page de démo minimaliste.

## Fonctionnalités
- Build front-end via `vite` (rolldown-vite) avec sorties CSS regroupées dans `public/assets/css`.
- Deux thèmes SCSS indépendants (`1.scss` et `2.scss`) construits sur une base commune (`base.scss`).
- Reset CSS moderne via `@use` dans `base.scss`, avec typographie et line-height (`150%`).
- Thèmes paramétrés par variables (`--color-*`, `--font-family`).

## Structure
```
BOSS/
├─ index.html
├─ package.json
├─ vite.config.js
├─ public/
│  └─ assets/
│     └─ css/
│        ├─ 1.css
│        └─ 2.css
└─ src/
   ├─ main.js
   ├─ style.css
   └─ styles/
      ├─ reset.scss
      ├─ base.scss
      ├─ 1.scss
      └─ 2.scss
```

### Fichiers clés
- `vite.config.js` configure les entrées SCSS et la sortie CSS (c:\Users\ludlemai\Sites\BOSS\vite.config.js:8–15).
- `index.html` charge la feuille de style générée (c:\Users\ludlemai\Sites\BOSS\index.html:6–8).
- `src/styles/base.scss` importe le reset, expose une palette commune et applique les variables au body (c:\Users\ludlemai\Sites\BOSS\src\styles\base.scss:1–24).
- `src/styles/1.scss` et `src/styles/2.scss` définissent les variables de thème (couleurs, police) (c:\Users\ludlemai\Sites\BOSS\src\styles\1.scss:1–9, c:\Users\ludlemai\Sites\BOSS\src\styles\2.scss:1–9).

## Prérequis
- Node.js 18+ recommandé.
- NPM 9+.

## Installation
- Cloner le dépôt.
- Installer les dépendances: `npm install`

## Scripts
- Développement: `npm run dev`
- Build production: `npm run build`
- Preview local: `npm run preview`

## Build et assets CSS
- Le build génère des fichiers CSS à partir des entrées SCSS définies dans `vite.config.js`.
- Sorties: `public/assets/css/1.css` et `public/assets/css/2.css`.
- Pour charger un thème dans `index.html`, lier la feuille correspondante, par exemple:
  - `\<link rel="stylesheet" href="/public/assets/css/1.css">`
  - ou `\<link rel="stylesheet" href="/public/assets/css/2.css">`

## Personnalisation des thèmes
- Modifier les variables de couleur dans `src/styles/1.scss` et `src/styles/2.scss`:
  - `--color-primary` et `--color-background` sont utilisées par `base.scss` pour le rendu (c:\Users\ludlemai\Sites\BOSS\src\styles\base.scss:3).
- `base.scss` importe le reset (c:\Users\ludlemai\Sites\BOSS\src\styles\base.scss:1) puis applique les variables au `body`.

## Noms de fichiers CSS (optionnel)
- Si vous souhaitez des noms explicites comme `boss.css` et `pf.css`, définissez des clés d’entrée et un schéma de sortie:
  - Dans `vite.config.js`, utilisez:
    - `rollupOptions.input = { boss: 'src/styles/1.scss', pf: 'src/styles/2.scss' }`
    - `rollupOptions.output.assetFileNames = 'css/[name][extname]'`
- Mettez à jour `index.html` pour référencer `boss.css` ou `pf.css`.

## Note sur publicDir / outDir
- Vite avertit si `build.outDir` (`public/assets`) et `publicDir` (`public`) ne sont pas séparés.
- Recommandation: utiliser `build.outDir = 'dist/assets'` et servir les assets depuis `dist`, ou conserver `public` pour les fichiers statiques non transformés.

## Dépannage
- Erreur: `Preprocessor dependency "sass-embedded" not found` → la dépendance est listée dans `devDependencies`; si nécessaire, réinstaller: `npm install`.
- Erreur Sass: `@use rules must be written before any other rules` → placer `@use` en tête des fichiers SCSS (ex. `1.scss` et `2.scss` commencent par `@use './base.scss';`).
- Nom de fichier inattendu (`1.css`/`2.css`) → ajuster `rollupOptions.input` et `assetFileNames` comme indiqué ci-dessus.
- Si vous voyez des avertissements Sass liés à Bootstrap, c’est que Bootstrap n’est plus utilisé dans ce projet; vérifiez qu’aucun import/bootstrap CDN ne subsiste.

## Aperçu local
- Build: `npm run build`
- Preview: `npm run preview` puis ouvrir l’URL indiquée en console.
