# BOSS Styleguide

Ce dossier contient le guide de style (Styleguide) du projet BOSS, regroupant l'ensemble des composants UI/UX standardisés.

## Fichier principal : `styleguide.html`

Le fichier `styleguide.html` sert de référence visuelle et technique pour les développeurs et designers. Il présente tous les composants disponibles avec leur rendu visuel et permet de copier facilement leur code HTML.

### Contenu du Styleguide

Le guide est organisé en sections thématiques :

1.  **Typographie** : Titres (H1, H2) et niveaux de paragraphes.
2.  **Spacing** : Système de grille basé sur 4px (XS, SM, MD, ML, LG, XL).
3.  **Boutons** :
    *   Types : Default, Primary, Secondary, Neutral.
    *   Tailles : XS, SM, MD, LG.
    *   États : Normal, Disabled.
4.  **Badges** : Variantes de couleurs (Primary, Secondary) et types spécifiques (Promo, Success Inline, Waiting, Notification).
5.  **Avatars** :
    *   Formes : Arrondi, Cercle.
    *   Variantes : Placeholder, Bordure extérieure, Statut (En ligne/Hors ligne).
    *   Stacks : Groupes d'avatars superposés.
6.  **Modals** : 4 modèles de cartes modales (Titre+Desc+Actions, Info seule, Avec icône de fermeture, etc.).
7.  **Cards (Cartes)** :
    *   **Gradient** : Cartes avec fond dégradé et image (ex: Coupe du monde, Classement).
    *   **White** : Cartes sur fond blanc (Standard, Avec tags).
    *   **Success** : Cartes de validation ou succès.
    *   **Alert** : Cartes d'alerte ou d'information critique.
8.  **Carrousels** : Composant de diaporama (basé sur Bootstrap).
9.  **Call To Action (CTA)** : Liens d'action.
10. **Grille** : Démonstration de la grille Bootstrap.
11. **Éléments HTML** : Listes (ordonnées/non-ordonnées), Figures.
12. **Formulaires** :
    *   Champs de saisie (Input, Textarea).
    *   Sélections (Select).
    *   Cases à cocher (Checkbox) et Boutons radio (avec tailles variées).
    *   Switches.

### Fonctionnalités

*   **Copie Rapide** : Chaque composant dispose d'un bouton de copie (<i data-feather="copy"></i>) qui apparaît au survol. Il permet de copier le code HTML brut du composant directement dans le presse-papier.
    *   Le script détecte automatiquement les éléments (boutons, badges, cartes, modales, etc.) et leur injecte le wrapper et le bouton de copie.

### Dépendances Techniques

*   **Bootstrap 5** : Framework CSS/JS de base.
*   **Feather Icons** : Bibliothèque d'icônes (utilisée notamment pour le bouton de copie).
*   **CSS Local** : `../public/assets/css/2.css` (Feuille de style principale du projet).

## Autres fichiers

*   `card.html` : Fichier source contenant les modèles de cartes (utilisés pour alimenter le styleguide).
*   `carrousel.html` : Fichier source contenant le modèle de carrousel.
*   `navbar.html` : Composant de navigation (Navbar) indépendant.
*   `template.html` : Structure de base pour les nouvelles pages.
