# Carrousel

Ce carrousel utilise les composants Bootstrap et un style spécifique (`carrousel.css`). Il est fluide (100%) et responsive.

## Intégration
- Inclure Bootstrap via CDN dans la page qui intègre le carrousel:
  - `\<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5/dist/css/bootstrap.min.css">`
  - `\<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js">\</script>`
- Inclure la feuille de style générée:
  - `\<link rel="stylesheet" href="/public/assets/css/carrousel.css">`
- Inclure le HTML du carrousel (exemple: `inc/carrousel.html`).

## Build
- Le fichier source SCSS est `src/styles/carrousel.scss`.
- Il est compilé pendant le build Vite en `public/assets/css/carrousel.css`.

## Ajouter ou supprimer un slide
- Les slides sont des `.carousel-item` dans `inc/carrousel.html`.
- Ajouter un slide:
  - Dupliquer un bloc `.carousel-item` et ajuster le contenu (titre, description, image).
  - Ajouter le bouton correspondant dans `.carousel-indicators` (incrémenter l’attribut `data-bs-slide-to`).
- Supprimer un slide:
  - Retirer le bloc `.carousel-item` visé.
  - Retirer le bouton correspondant dans `.carousel-indicators`.
- Le premier slide doit avoir la classe `active`.

## Images
- Les images d’exemple pointent vers des fichiers du dossier `maquette/`.
- Vous pouvez remplacer l’attribut `src` par un autre chemin.

## Personnalisation
- Les couleurs utilisent les variables définies dans `base.scss` (`--color-white`, `--color-secondary`, `--soft-grey`).
- Vous pouvez modifier les espacements, coins arrondis, ombres dans `src/styles/carrousel.scss`.

## Accessibilité
- Chaque slide possède un `alt` descriptif.
- Les contrôles utilisent le texte `Précédent/Suivant` via `visually-hidden`.
