import { _ as BindingReplacePluginConfig } from "./shared/binding-BTw1cXhU.mjs";
import { t as BuiltinPlugin } from "./shared/utils-BxvnUO-9.mjs";
import { r as esmExternalRequirePlugin } from "./shared/constructors-BGT3rFMD.mjs";

//#region src/builtin-plugin/replace-plugin.d.ts

/**
* Replaces targeted strings in files while bundling.
*
* @example
* // Basic usage
* ```js
* replacePlugin({
*   'process.env.NODE_ENV': JSON.stringify('production'),
*    __buildVersion: 15
* })
* ```
* @example
* // With options
* ```js
* replacePlugin({
*   'process.env.NODE_ENV': JSON.stringify('production'),
*   __buildVersion: 15
* }, {
*   preventAssignment: false,
* })
* ```
*/
declare function replacePlugin(values?: BindingReplacePluginConfig["values"], options?: Omit<BindingReplacePluginConfig, "values">): BuiltinPlugin;
//#endregion
export { esmExternalRequirePlugin, replacePlugin };