document.addEventListener("DOMContentLoaded", function() {
    // NAVBAR
    const nav = document.querySelector('.boss-navbar-left');
    const btns = document.querySelectorAll('.deployed-btn, .deployed-btn-collapsed');
    if (nav && btns.length) {
        const toggle = () => {
            const willExpand = !nav.classList.contains('expanded');
            nav.classList.toggle('expanded');
            nav.classList.toggle('collapsed');
            btns.forEach(b => b.setAttribute('aria-expanded', willExpand ? 'true' : 'false'));
        };
        btns.forEach(btn => btn.addEventListener('click', toggle));
    }

    const toggleStateBtn = document.getElementById('toggle-state');
    if (toggleStateBtn && nav) {
        toggleStateBtn.addEventListener('click', () => {
            const currentState = nav.getAttribute('data-state');
            const newState = currentState === 'connected' ? 'disconnected' : 'connected';
            
            // If switching to disconnected, force expanded state
            if (newState === 'disconnected') {
                btns.forEach(b => b.setAttribute('aria-expanded', 'true'));
            }
        });
    }
    
    // Initialize icons
    feather.replace();
});